<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\User\TransactionController;
use App\Http\Controllers\User\BankAccountController;
use App\Http\Controllers\TicketController;
use App\Models\Bank;
use App\Models\BankAccount;
use App\Models\News;

Route::middleware(['auth', 'user'])->group(function () {

    Route::get('transactions/filter', [TransactionController::class, 'filter'])->name('transactions.filter');
    Route::resource('transactions', TransactionController::class);

    // Ticket routes
    Route::post('tickets/{ticket}/reply', [TicketController::class, 'reply'])->name('tickets.reply');
    Route::post('tickets/mark-all-read', [TicketController::class, 'markAllAsRead'])->name('tickets.mark-all-read');
    Route::resource('tickets', TicketController::class);

    // Topup endpoint
    Route::post('transactions/topup', [TransactionController::class, 'topup'])->name('transactions.topup');

    // Withdrawal endpoint
    Route::post('transactions/withdrawal', [TransactionController::class, 'withdrawal'])->name('transactions.withdrawal');

    // Bank account management
    Route::patch('bank-accounts/{bankAccount}/toggle-status', [BankAccountController::class, 'toggleStatus'])->name('bank-accounts.toggle-status');
    Route::resource('bank-accounts', BankAccountController::class);

    // Password change endpoint
    Route::post('change-password', [App\Http\Controllers\Api\PasswordController::class, 'changePassword'])->name('password.update');

    // API endpoints
    Route::prefix('api')->group(function () {
        Route::get('banks', function () {
            $bankAccounts = Bank::where('is_active', true)
                ->get();
            return response()->json($bankAccounts);
        });
        Route::get('bank-account/admin', function () {
            $bankAccounts = BankAccount::with('bank')
                ->where('is_active', true)
                ->whereNull('user_id')
                ->get();
            return response()->json($bankAccounts);
        });
        Route::get('bank-account/user', function () {
            $user = auth()->user();
            $bankAccounts = BankAccount::with('bank')
                ->where('user_id', $user->id)
                ->where('is_active', true)
                ->get();
            return response()->json($bankAccounts);
        });
        Route::get('news', function () {
            $news = News::get();
            return response()->json($news);
        });
        Route::get('user/balance', function () {
            $user = auth()->user();
            return response()->json([
                'balance' => $user->balance,
                'formatted_balance' => $user->formatted_balance
            ]);
        });

        Route::get('system-messages', function () {
            $user = auth()->user();
            $messages = \App\Models\SystemMessage::getActiveMessagesForUser($user->id);
            return response()->json($messages);
        });
    });

    Route::get('/', function () {
        return Inertia::render('dashboard');
    })->name('home');

    Route::get('profile', function () {
        return Inertia::render('profile');
    })->name('profile');
});

// PIN management endpoints
Route::middleware(['auth', 'user'])->prefix('api')->group(function () {
    Route::get('pin/check', [App\Http\Controllers\User\PinController::class, 'checkPin'])->name('pin.check');
    Route::post('pin/create', [App\Http\Controllers\User\PinController::class, 'createPin'])->name('pin.create');
    Route::post('pin/update', [App\Http\Controllers\User\PinController::class, 'updatePin'])->name('pin.update');
    Route::post('pin/verify', [App\Http\Controllers\User\PinController::class, 'verifyPin'])->name('pin.verify');
});
