<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\BankController;
use App\Http\Controllers\Admin\BankAccountController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\TicketController;
use App\Http\Controllers\Admin\SystemMessageController;
use App\Http\Controllers\Admin\SystemSettingController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // Users management
    Route::resource('users', UserController::class);
    Route::patch('users/{user}/toggle-verification', [UserController::class, 'toggleVerification'])
        ->name('users.toggle-verification');
    Route::post('users/{user}/add-balance', [UserController::class, 'addBalance'])
        ->name('users.add-balance');
    Route::post('users/{user}/reduce-balance', [UserController::class, 'reduceBalance'])
        ->name('users.reduce-balance');

    // Banks management
    Route::resource('banks', BankController::class);

    // Bank Accounts management
    Route::resource('bank-accounts', BankAccountController::class)
        ->except(['show']);

    // For toggle status
    Route::post('bank-accounts/{bankAccount}/toggle-status', [BankAccountController::class, 'toggleStatus'])
        ->name('bank-accounts.toggle-status');

    // News management
    Route::resource('news', NewsController::class);

    // Tickets management
    Route::post('tickets/{ticket}/reply', [TicketController::class, 'reply'])->name('tickets.reply');
    Route::patch('tickets/{ticket}/status', [TicketController::class, 'updateStatus'])->name('tickets.update-status');
    
    // API endpoint for unread count
    Route::get('tickets/unread-count', [TicketController::class, 'getUnreadCount'])->name('tickets.unread-count');
    
    Route::resource('tickets', TicketController::class)->except(['edit', 'update', 'create']);

    // Transactions management
    Route::resource('transactions', TransactionController::class);
    Route::patch('transactions/{transaction}/status', [TransactionController::class, 'updateStatus'])->name('transactions.update-status');

    // System Messages management
    Route::resource('system-messages', SystemMessageController::class);
    Route::patch('system-messages/{systemMessage}/toggle-status', [SystemMessageController::class, 'toggleStatus'])
        ->name('system-messages.toggle-status');
    Route::post('system-messages/update-order', [SystemMessageController::class, 'updateOrder'])
        ->name('system-messages.update-order');

    // System Settings management
    Route::get('system-settings', [SystemSettingController::class, 'index'])->name('system-settings.index');
    Route::post('system-settings', [SystemSettingController::class, 'update'])->name('system-settings.update');
});
