import { LucideIcon } from 'lucide-react';
import type { Config } from 'ziggy-js';

export interface PaginationProps<T> {
    data: T[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
    links: {
        url: string | null;
        label: string;
        active: boolean;
    }[];
}

export interface User {
    id: number;
    name: string;
    email: string;
    email_verified_at: string | null;
    phone_number: string;
    role: string;
    is_verified: boolean;
    pin_hash?: string | null;
    created_at: string;
    updated_at: string;
    balance?: number;
}

export interface SystemMessage {
    id: number;
    title: string;
    message: string;
    is_active: boolean;
    display_order: number;
    users: User[];
    created_at: string;
    updated_at: string;
}

export interface Bank {
    id: number;
    name: string;
    logo: string | null;
    is_active: boolean;
    created_at: string;
    updated_at: string;
}

export interface BankAccount {
    id: number;
    bank_id: number;
    user_id?: number;
    account_number: string;
    account_name: string;
    is_active: boolean;
    created_at: string;
    updated_at: string;
    bank?: Bank;
    user?: User;
}

export interface NewsProps {
    id: number;
    title: string;
    description: string;
    image: string | null;
    user_id: number;
    created_at: string;
    updated_at: string;
    user?: User;
}

export interface TicketAttachment {
    name: string;
    path: string;
    type: string;
}

export interface TicketReply {
    id: number;
    ticket_id: number;
    user_id: number;
    content: string;
    attachments?: TicketAttachment[];
    created_at: string;
    updated_at: string;
    user?: User;
}

export interface Ticket {
    id: number;
    title: string;
    description: string;
    status: 'open' | 'in_progress' | 'resolved' | 'closed';
    priority: 'low' | 'medium' | 'high';
    user_id: number;
    resolved_at: string | null;
    attachments?: TicketAttachment[];
    last_viewed_by_admin?: string | null;
    is_read?: boolean;
    created_at: string;
    updated_at: string;
    user?: User;
    replies?: TicketReply[];
}

export interface Transaction {
    id: number;
    amount: number;
    type: string;
    status: 'pending' | 'processing' | 'completed' | 'failed';
    reference: string;
    recipient: string;
    evidence?: string;
    notes?: string;
    user_id: number;
    bank_account_id?: number;
    created_at: string;
    updated_at: string;
    user?: User;
    bank_account?: BankAccount;
}

export interface PaginationMeta {
    current_page: number;
    from: number;
    last_page: number;
    path: string;
    per_page: number;
    to: number;
    total: number;
}

export interface PaginatedResponse<T> {
    data: T[];
    links: Array<{
        url: string | null;
        label: string;
        active: boolean;
    }>;
    meta: PaginationMeta;
}

export interface FlashMessage {
    success?: string;
    error?: string;
    warning?: string;
    info?: string;
}

export interface PageProps<T = Record<string, unknown>> {
    auth: Auth;
    flash?: FlashMessage;

    [key: string]: any;
}

export interface BreadcrumbItemProps {
    title: string;
    href: string;
}


export interface Auth {
    user: User;
}

export interface BreadcrumbItem {
    title: string;
    href: string;
}

export interface NavGroup {
    title: string;
    items: NavItem[];
}

export interface NavItem {
    title: string;
    href: string;
    icon?: LucideIcon | null;
    isActive?: boolean;
}

export interface SharedData {
    name: string;
    quote: { message: string; author: string };
    auth: Auth;
    ziggy: Config & { location: string };
    sidebarOpen: boolean;

    [key: string]: unknown;
}

export type TransactionProps = {
    id: number;
    type: string;
    amount: string;
    status: string;
    reference: string;
    recipient: string;
    evidence?: string; // URL to evidence image
    notes?: string;
    created_at: string;
    updated_at: string;
}
