import { Head } from '@inertiajs/react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Plus, MessageCircle } from 'lucide-react';
import DashboardLayout from '@/layouts/dashboard-layout';
import TicketSystem from '@/components/user/profile/ticket-system';
import { Ticket } from '@/types';
import { PaginationProps } from '@/types';

interface TicketIndexProps {
    tickets: PaginationProps<Ticket>;
}

export default function TicketIndex({ tickets }: TicketIndexProps) {
    return (
        <DashboardLayout>
            <Head title="Tiket Sokongan" />

            <div className="p-6 space-y-6">
                {/* Header */}
                <div className="flex items-center justify-between">
                    <div>
                        <h1 className="text-3xl font-bold text-gray-900">Tiket Sokongan</h1>
                        <p className="text-gray-600">Urus tiket sokongan anda</p>
                    </div>
                    <Button className="gap-2">
                        <Plus className="w-4 h-4" />
                        Tiket Baru
                    </Button>
                </div>

                {/* Ticket System Component */}
                <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2">
                            <MessageCircle className="w-5 h-5" />
                            Sistem Tiket
                        </CardTitle>
                    </CardHeader>
                    <CardContent>
                        <TicketSystem 
                            trigger={
                                <Button className="w-full gap-2">
                                    <MessageCircle className="w-4 h-4" />
                                    Buka Sistem Tiket
                                </Button>
                            }
                            tickets={tickets.data}
                        />
                    </CardContent>
                </Card>

                {/* Quick Stats */}
                <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <Card>
                        <CardContent className="p-4">
                            <div className="text-center">
                                <div className="text-2xl font-bold text-blue-600">
                                    {tickets.data.filter(t => t.status === 'open').length}
                                </div>
                                <div className="text-sm text-gray-600">Tiket Terbuka</div>
                            </div>
                        </CardContent>
                    </Card>
                    <Card>
                        <CardContent className="p-4">
                            <div className="text-center">
                                <div className="text-2xl font-bold text-yellow-600">
                                    {tickets.data.filter(t => t.status === 'in_progress').length}
                                </div>
                                <div className="text-sm text-gray-600">Dalam Proses</div>
                            </div>
                        </CardContent>
                    </Card>
                    <Card>
                        <CardContent className="p-4">
                            <div className="text-center">
                                <div className="text-2xl font-bold text-green-600">
                                    {tickets.data.filter(t => t.status === 'resolved').length}
                                </div>
                                <div className="text-sm text-gray-600">Selesai</div>
                            </div>
                        </CardContent>
                    </Card>
                    <Card>
                        <CardContent className="p-4">
                            <div className="text-center">
                                <div className="text-2xl font-bold text-gray-600">
                                    {tickets.data.filter(t => t.status === 'closed').length}
                                </div>
                                <div className="text-sm text-gray-600">Ditutup</div>
                            </div>
                        </CardContent>
                    </Card>
                </div>
            </div>
        </DashboardLayout>
    );
}
