import HistoryTransaction from "@/components/user/history-transaction";
import Topup from "@/components/user/transactions/Topup";
import DashboardLayout from "@/layouts/dashboard-layout";
import { PageProps } from "@/types";
import { Head } from "@inertiajs/react";

interface TransactionPageProps extends PageProps {
    transactions: {
        data: Array<{
            id: number;
            type: string;
            amount: string;
            status: string;
            reference: string;
            recipient: string;
            evidence?: string;
            notes?: string;
            created_at: string;
            updated_at: string;
        }>;
        current_page: number;
        last_page: number;
        per_page: number;
        total: number;
        links: Array<{
            url: string | null;
            label: string;
            active: boolean;
        }>;
    };
}

const Transaction = ({ auth }: TransactionPageProps) => {
    return (
        <DashboardLayout auth={auth}>
            <Head title="Transaction" />
            <div className="p-4 space-y-4">
                <Topup />
                <HistoryTransaction />
            </div>
        </DashboardLayout>
    );
}

export default Transaction;
