import { Head } from '@inertiajs/react';
import DashboardLayout from '@/layouts/dashboard-layout';
import { PageProps } from '@/types';
import { Landmark, Key, User, Shield } from 'lucide-react';
import News from '@/components/user/news';
import ChangePassword from '@/components/user/profile/change-password';
import AccountBank from '@/components/user/profile/account-bank';
import ChangePin from '@/components/user/profile/change-pin';
import TicketSystem from '@/components/user/profile/ticket-system';
import { useState, useEffect } from 'react';
import { useApiClient } from '@/lib/api';

export default function Profile({ auth }: PageProps) {
    const [hasPin, setHasPin] = useState<boolean | null>(null);
    const [isCheckingPin, setIsCheckingPin] = useState(true);
    const apiClient = useApiClient();

    useEffect(() => {
        const checkPinStatus = async () => {
            try {
                const response = await apiClient.get('/api/pin/check');
                if (response.ok) {
                    const data = await response.json();
                    setHasPin(data.has_pin);
                }
            } catch (error) {
                console.error('Error checking PIN status:', error);
            } finally {
                setIsCheckingPin(false);
            }
        };

        checkPinStatus();
    }, [apiClient]);

    const handlePinSet = () => {
        setHasPin(true);
    };

    return (
        <DashboardLayout auth={auth}>
            <Head title="Profil" />

            <div className="p-4 space-y-6">
                {/* Butiran Akaun */}
                <div className="space-y-2">
                    <h3 className="text-lg font-semibold flex items-center gap-2 text-white">
                        <User className="w-5 h-5" />
                        MAKLUMAT AKAUN
                    </h3>
                    <div className="space-y-4">
                        <div className="px-4 py-2 bg-foreground/30 rounded-lg">
                            <div className="text-xs font-bold text-muted">Nombor Telefon</div>
                            <div className="font-medium text-primary-foreground">{auth.user.phone_number}</div>
                        </div>
                        <div className="px-4 py-2 bg-foreground/30 rounded-lg">
                            <div className="text-sm text-muted">E-mel</div>
                            <div className="font-medium text-primary-foreground">{auth.user.email}</div>
                        </div>
                    </div>
                </div>

                {/* Keselamatan & Tetapan */}
                <div className="space-y-2">
                    <h3 className="text-lg font-semibold flex items-center gap-2 text-white">
                        <Shield className="w-5 h-5" />
                        KESELAMATAN & TETAPAN
                    </h3>
                    <div className="space-y-2">
                        <ChangePassword/>

                        <AccountBank/>

                        {!isCheckingPin && (
                            <ChangePin 
                                user={auth.user} 
                                hasPin={hasPin ?? undefined}
                                forceOpen={!hasPin}
                                onPinSet={handlePinSet}
                            />
                        )}

                        <TicketSystem/>
                    </div>
                </div>

                {/* Seksyen Berita */}
                <News />
            </div>
        </DashboardLayout>
    );
}
