import { Form, Head } from '@inertiajs/react';
import { LoaderCircle } from 'lucide-react';

import InputError from '@/components/input-error';
import TextLink from '@/components/text-link';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import AuthLayout from '@/layouts/auth-layout';
import { Checkbox } from '@/components/ui/checkbox';
import CaptchaInput from '@/components/ui/captcha-input';

export default function Register({ captcha }: { captcha?: string }) {
    return (
        <AuthLayout title='Selamat datang di akaun peribadi BNM Personal, Sila Buat Akaun BNM.'>
            <Head title="Daftar" />
            <Form
                method="post"
                action={route('register')}
                resetOnSuccess={['password', 'password_confirmation']}
                disableWhileProcessing
                className="flex flex-col gap-6 text-white"
            >
                {({ processing, errors }) => (
                    <>
                        <div className="grid gap-6">
                            <div className="grid gap-2">
                                <Label htmlFor="name">NAMA PENUH</Label>
                                <Input
                                    id="name"
                                    type="text"
                                    required
                                    autoFocus
                                    tabIndex={1}
                                    autoComplete="name"
                                    name="name"
                                    className="rounded-full"
                                />
                                <InputError message={errors.name} className="mt-2" />
                            </div>

                            <div className="grid gap-2">
                                <Label htmlFor="email">E-MEL</Label>
                                <Input
                                    id="email"
                                    type="email"
                                    required
                                    tabIndex={2}
                                    autoComplete="email"
                                    name="email"
                                    className="rounded-full"
                                />
                                <InputError message={errors.email} />
                            </div>

                            <div className="grid gap-2">
                                <Label htmlFor="phone_number">NOMBOR TELEFON</Label>
                                <Input
                                    id="phone_number"
                                    type="tel"
                                    required
                                    tabIndex={3}
                                    autoComplete="tel"
                                    name="phone_number"
                                    className="rounded-full"
                                />
                                <InputError message={errors.phone_number} />
                            </div>

                            <div className="grid gap-2">
                                <Label htmlFor="password">KATA LALUAN</Label>
                                <Input
                                    id="password"
                                    type="password"
                                    required
                                    tabIndex={4}
                                    autoComplete="new-password"
                                    name="password"
                                    className="rounded-full"
                                />
                                <InputError message={errors.password} />
                            </div>

                            <div className="grid gap-2">
                                <Label htmlFor="verification_code">KODE VERIFIKASI</Label>
                                <CaptchaInput
                                    id="verification_code"
                                    name="verification_code"
                                    placeholder="Masukkan kode verifikasi"
                                    required
                                    tabIndex={5}
                                    captchaValue={captcha}
                                />
                                <InputError message={errors.verification_code} />
                            </div>

                            <div className="grid gap-2">
                                <div className="flex items-center space-x-3">
                                    <Checkbox id="accept_term_condition" name="accept_term_condition" tabIndex={6} className="rounded border-white data-[state=checked]:bg-white data-[state=checked]:text-blue-900" />
                                    <Label htmlFor="accept_term_condition">Bersetuju Syarat Dan Terma Perjanjian Pengguna</Label>
                                </div>
                                <InputError message={errors.accept_term_condition} />
                            </div>

                            <Button type="submit" className="w-full rounded-full bg-blue-600 text-white font-bold py-4 hover:bg-blue-700" tabIndex={7} disabled={processing}>
                                {processing && <LoaderCircle className="h-4 w-4 animate-spin" />}
                                DAFTAR
                            </Button>
                        </div>

                        <div className="text-center text-sm">
                            <p>Sudah Mempunyai Akaun?</p>
                            <TextLink href={route('login')} tabIndex={7} className="font-bold text-yellow-300">
                                LOG MASUK
                            </TextLink>
                        </div>


                    </>
                )}
            </Form>
        </AuthLayout>
    );
}
