import InputError from '@/components/input-error';
import TextLink from '@/components/text-link';
import { Button } from '@/components/ui/button';
import { Checkbox } from '@/components/ui/checkbox';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import AuthLayout from '@/layouts/auth-layout';
import { Form, Head } from '@inertiajs/react';
import { LoaderCircle } from 'lucide-react';

interface LoginProps {
    status?: string;
    canResetPassword: boolean;
}

export default function Login({ status, canResetPassword }: LoginProps) {
    return (
        <AuthLayout title='Selamat datang di akaun peribadi BNM Personal, Sila Log Masuk Dalam Akaun BNM.'>
            <Head title="Log in" />

            <Form method="post" action={route('login')} resetOnSuccess={['password']} className="flex flex-col gap-6 text-white">
                {({ processing, errors }) => (
                    <>
                        <div className="grid gap-6">
                            <div className="grid gap-2">
                                <Label htmlFor="email">E-MEL</Label>
                                <Input
                                    id="email"
                                    type="email"
                                    name="email"
                                    required
                                    autoFocus
                                    tabIndex={1}
                                    autoComplete="email"
                                    className="rounded-full"
                                    error={errors.email}
                                />
                            </div>

                            <div className="grid gap-2">
                                <Label htmlFor="password">KATA LALUAN</Label>
                                <Input
                                    id="password"
                                    type="password"
                                    name="password"
                                    required
                                    tabIndex={2}
                                    autoComplete="current-password"
                                    className="rounded-full"
                                    error={errors.password}
                                />
                                {canResetPassword && (
                                    <TextLink href={route('password.request')} className="ml-auto text-sm text-white" tabIndex={5}>
                                        Terlupa Kata Laluan
                                    </TextLink>
                                )}
                            </div>

                            <div className="grid gap-2">
                                <div className="flex items-center space-x-3">
                                    <Checkbox id="accept_term_condition" name="accept_term_condition" tabIndex={3} className="rounded border-white data-[state=checked]:bg-white data-[state=checked]:text-blue-900" />
                                    <Label htmlFor="accept_term_condition">Bersetuju Syarat Dan Terma Perjanjian Pengguna</Label>
                                </div>
                                <InputError message={errors.accept_term_condition} />
                            </div>

                            <Button type="submit" className="w-full rounded-full bg-blue-600 text-white font-bold py-4 hover:bg-blue-700" tabIndex={4} disabled={processing}>
                                {processing && <LoaderCircle className="h-4 w-4 animate-spin" />}
                                LOG MASUK
                            </Button>
                        </div>

                        <div className="text-center text-sm">
                            <p>Belum Mendaftar Sebagai Pengguna</p>
                            <TextLink href={route('register')} tabIndex={5} className="font-bold text-yellow-300">
                                BUAT AKAUN
                            </TextLink>
                        </div>
                    </>
                )}
            </Form>

            {status && <div className="mb-4 text-center text-sm font-medium text-green-600">{status}</div>}
        </AuthLayout>
    );
}
