// Components
import { Form, Head } from '@inertiajs/react';
import { LoaderCircle } from 'lucide-react';

import InputError from '@/components/input-error';
import TextLink from '@/components/text-link';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import AuthLayout from '@/layouts/auth-layout';

export default function ForgotPassword({ status }: { status?: string }) {
    return (
        <AuthLayout title='Terlupa kata laluan? Masukkan e-mel berdaftar untuk menerima pautan set semula Akaun BNM Personal.'>
            <Head title="Terlupa Kata Laluan" />

            {status && <div className="text-center text-sm font-medium bg-green-600 text-white p-2 rounded-full">{status}</div>}

            <div className="space-y-6">
                <Form method="post" action={route('password.email')} className="text-white">
                    {({ processing, errors }) => (
                        <>
                            <div className="grid gap-2">
                                <Label htmlFor="email">E-MEL</Label>
                                <Input
                                    id="email"
                                    type="email"
                                    name="email"
                                    autoComplete="off"
                                    autoFocus
                                    className="rounded-full"
                                />

                                <InputError message={errors.email} />
                            </div>

                            <div className="my-6 flex items-center justify-start">
                                <Button type="submit" className="w-full rounded-full bg-blue-600 text-white font-bold py-4 hover:bg-blue-700" tabIndex={4} disabled={processing}>
                                    {processing && <LoaderCircle className="h-4 w-4 animate-spin" />}
                                    HANTAR PAUTAN TETAPAN SEMULA
                                </Button>
                            </div>
                        </>
                    )}
                </Form>

                <div className="text-center text-sm text-white space-x-2">
                    <span>Kembali ke</span>
                    <TextLink href={route('login')} className="font-bold text-yellow-300">LOG MASUK</TextLink>
                </div>
            </div>
        </AuthLayout>
    );
}
