import InputError from '@/components/input-error';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import AuthLayout from '@/layouts/auth-layout';
import { Form, Head } from '@inertiajs/react';
import { LoaderCircle } from 'lucide-react';

export default function ConfirmPassword() {
    return (
        <AuthLayout title='Sila masukkan kata laluan yang telah didaftarkan untuk log masuk.'>
            <Head title="Sahkan Kata Laluan" />

            <Form method="post" action={route('password.confirm')} resetOnSuccess={['password']} className="text-white">
                {({ processing, errors }) => (
                    <div className="space-y-6">
                        <div className="grid gap-2">
                            <Label htmlFor="password">KATA LALUAN</Label>
                            <Input 
                                id="password" 
                                type="password" 
                                name="password" 
                                autoComplete="current-password" 
                                autoFocus 
                                className="rounded-full"
                            />

                            <InputError message={errors.password} />
                        </div>

                        <div className="flex items-center">
                            <Button className="w-full rounded-full bg-blue-600 py-6 text-lg hover:bg-blue-700" disabled={processing}>
                                {processing && <LoaderCircle className="h-4 w-4 animate-spin" />}
                                SAHKAN KATA LALUAN
                            </Button>
                        </div>
                    </div>
                )}
            </Form>
        </AuthLayout>
    );
}
