import { type ClassValue, clsx } from 'clsx';
import { twMerge } from 'tailwind-merge';
import dayjs from 'dayjs';

export function cn(...inputs: ClassValue[]) {
    return twMerge(clsx(inputs));
}
export const formatAmount = (amount: string | number) => {
    const numAmount = parseFloat(amount.toString());
    return `RM ${Number(numAmount).toLocaleString('en-MY', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
};

export const formatDate = (dateString: string) => {
    return dayjs(dateString).format('DD MMM • HH:mm:ss');
};

export const generateInital = (name: string) => {
    return name
        .split(' ')
        .map((word) => word.charAt(0).toUpperCase())
        .slice(0, 2)
        .join('');
}
