import { Link } from '@inertiajs/react';
import { cn } from '@/lib/utils';
import usePathname from '@/hooks/use-pathname';
import { Home, Repeat, User } from 'lucide-react';
import Header from '@/components/user/header';
import { Auth } from '@/types';
import { ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';
import PinCheck from '@/components/PinCheck';

type Props = {
    children: React.ReactNode;
    auth: Auth
}

export default function DashboardLayout({ children, auth }: Props) {
    const pathname = usePathname();

    return (
        <>
            <PinCheck auth={auth}>
                <div className="mx-auto flex min-h-screen w-full flex-col bg-primary md:max-w-[375px]">
                    <Header auth={auth} />
                    <main className="flex-1 pb-20">{children}</main>

                    <nav className="fixed bottom-0 left-0 right-0 border-t border-white/10 md:max-w-[375px] mx-auto">
                        <div className="grid grid-cols-3 items-center justify-between bg-[#002B5B] py-3">
                            <Link
                                href={route('transactions.index')}
                                className={cn(
                                    'flex flex-col items-center gap-1 text-xs font-medium text-white/60 transition-colors',
                                    pathname === '/transaction' && 'text-white'
                                )}
                            >
                                <Repeat className="h-6 w-6" />
                                TRANSACTION
                            </Link>
                            <Link
                                href={route('home')}
                                className={cn(
                                    'flex flex-col items-center gap-1 text-xs font-medium text-white/60 transition-colors',
                                    pathname === '/' && 'text-white'
                                )}
                            >
                                <Home className="h-6 w-6" />
                                HOME
                            </Link>
                            <Link
                                href={route('profile')}
                                className={cn(
                                    'flex flex-col items-center gap-1 text-xs font-medium text-white/60 transition-colors',
                                    pathname === '/profile' && 'text-white'
                                )}
                            >
                                <User className="h-6 w-6" />
                                AKAUN
                            </Link>
                        </div>
                    </nav>
                </div>
            </PinCheck>
            {/* Toast Container */}
            <ToastContainer
                position="top-right"
                autoClose={5000}
                hideProgressBar={false}
                newestOnTop={false}
                closeOnClick
                rtl={false}
                pauseOnFocusLoss={false}
                draggable
                pauseOnHover={false}
                theme="colored"
            />
        </>
    );
}
