import AppLogo from '@/components/app-logo';

type Props = { children: React.ReactNode, title: string }

export default function AuthSimpleLayout({ children, title }: Props) {
    return (
        <div className="flex min-h-svh flex-col items-center justify-center bg-primary p-6">
            <div className="mx-auto w-full" style={{ maxWidth: '375px' }}>
                <div className="flex flex-col gap-8">
                    <div className="flex flex-col items-center gap-4">
                        <div className="rounded-2xl bg-primary-foreground px-6 py-2 text-center text-white w-full">
                            <AppLogo className="mx-auto w-20 fill-current mb-2" />
                            <p className="font-bold text-primary">
                                BANK NEGARA MALAYSIA
                            </p>
                            <p className='font-bold text-xs text-primary'>CENTRAL BANK OF MALAYSIA</p>
                        </div>
                        <p className="text-sm text-primary-foreground">
                            {title}
                        </p>
                    </div>
                    {children}
                </div>
            </div>
        </div>
    );
}
