import { ChevronRight, History } from 'lucide-react';
import { useState } from 'react';
import { usePage } from '@inertiajs/react';
import TransactionList from '@/components/user/transactions/TransactionList';
import { TransactionProps } from '@/types';
import TransactionDetail from '@/components/user/transactions/TransactionDetail';
import TransactionItem from '@/components/user/transactions/TransactionItem';
import EmptyData from '@/components/empty-data';

interface PaginationProps<T> {
    data: T[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
    links: Array<{
        url: string | null;
        label: string;
        active: boolean;
    }>;
}

type PageProps = {
    transactions: PaginationProps<TransactionProps>
}

const HistoryTransaction = () => {
    const { transactions } = usePage<PageProps>().props;
    const [selectedTransaction, setSelectedTransaction] = useState<TransactionProps | null>(null);
    const [isHistorySheetOpen, setIsHistorySheetOpen] = useState(false);

    return (
        <>
            <div className="space-y-2">
                <button
                    onClick={() => setIsHistorySheetOpen(true)}
                    className="flex flex-row items-center justify-between w-full hover:bg-foreground/40 rounded-md cursor-pointer">
                    <div className="flex flex-row space-x-2 items-center text-white">
                        <History className="h-6 w-6" />
                        <h3 className="text-lg font-semibold">Transaksi Terkini</h3>
                    </div>
                    <ChevronRight className="h-6 w-6 text-white" />
                </button>
                <div className="space-y-3">
                    {transactions.data.map((transaction) => (
                        <TransactionItem
                            key={transaction.id}
                            data={transaction}
                            onShowDetail={setSelectedTransaction}
                        />
                    ))}
                    {
                        transactions.data.length === 0 && (
                            <EmptyData />
                        )
                    }
                </div>
            </div>

            <TransactionList isOpen={isHistorySheetOpen} onClose={() => setIsHistorySheetOpen(false)} />

            {/* Transaction Detail Sheet */}
            <TransactionDetail
                data={selectedTransaction}
                isOpen={!!selectedTransaction}
                onClose={() => {
                    setSelectedTransaction(null);
                }} />
        </>
    );
};

export default HistoryTransaction;
