import { Sheet, SheetContent, SheetHeader, SheetTitle, SheetTrigger } from '@/components/ui/sheet';
import { LockKeyhole } from 'lucide-react';
import { useState } from 'react';

interface UpcomingFeatureProps {
    trigger: React.ReactElement;
}

export default function UpcomingFeature({ trigger }: UpcomingFeatureProps) {
    const [isOpen, setIsOpen] = useState(false);

    return (
        <Sheet open={isOpen} onOpenChange={setIsOpen}>
            {trigger && <SheetTrigger asChild>{trigger}</SheetTrigger>}
            <SheetContent side='bottom' theme='light' className="max-w-sm mx-auto overflow-y-auto">
                <SheetHeader>
                    <SheetTitle className="flex items-center gap-2">
                        <LockKeyhole />
                        <span>Upcoming Feature</span>
                    </SheetTitle>
                </SheetHeader>

                <div className="space-y-4 px-4 pb-4">
                    <svg
                        viewBox="0 0 320 200"
                        className="mx-auto h-48 w-auto"
                        role="img"
                        aria-label="Feature locked illustration"
                    >
                        <defs>
                            <linearGradient id="g1" x1="0" y1="0" x2="1" y2="1">
                                <stop offset="0%" stopColor="#6366F1" />
                                <stop offset="100%" stopColor="#22D3EE" />
                            </linearGradient>
                            <radialGradient id="g2" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" stopColor="#A5B4FC" stopOpacity="0.35" />
                                <stop offset="100%" stopColor="#93C5FD" stopOpacity="0.05" />
                            </radialGradient>
                            <filter id="blur" x="-50%" y="-50%" width="200%" height="200%">
                                <feGaussianBlur stdDeviation="18" />
                            </filter>
                        </defs>

                        {/* soft glow */}
                        <ellipse cx="160" cy="110" rx="120" ry="70" fill="url(#g2)" filter="url(#blur)" />

                        {/* platform */}
                        <rect x="60" y="140" width="200" height="16" rx="8" fill="#F1F5F9" />
                        <rect x="85" y="150" width="150" height="8" rx="4" fill="#E2E8F0" />

                        {/* lock shackle */}
                        <rect
                            x="130"
                            y="42"
                            width="60"
                            height="54"
                            rx="27"
                            fill="none"
                            stroke="#1F2937"
                            strokeWidth="6"
                            strokeOpacity="0.9"
                        />

                        {/* lock body */}
                        <rect x="112" y="86" width="96" height="70" rx="14" fill="url(#g1)" />
                        <rect x="112" y="86" width="96" height="70" rx="14" fill="#111827" opacity="0.06" />

                        {/* keyhole */}
                        <circle cx="160" cy="118" r="10" fill="#0F172A" opacity="0.85" />
                        <rect x="156" y="118" width="8" height="16" rx="4" fill="#0F172A" opacity="0.85" />

                        {/* sparkles */}
                        <circle cx="95" cy="60" r="3" fill="#A78BFA" />
                        <circle cx="225" cy="72" r="2.5" fill="#60A5FA" />
                        <circle cx="108" cy="92" r="2" fill="#34D399" />
                        <circle cx="212" cy="98" r="2" fill="#FBBF24" />
                    </svg>
                    <p className="text-sm text-gray-600 text-center">
                        This feature is under development. Get a quick look at what&rsquo;s coming and optionally
                        join the early-access list to be notified.
                    </p>
                </div>
            </SheetContent>
        </Sheet>
    );
}
