import { cn } from '@/lib/utils';
import { AnchorHTMLAttributes, HTMLAttributes } from 'react';

export default function TextLink({ className = '', ...props }: AnchorHTMLAttributes<HTMLAnchorElement>) {
    return (
        <a
            {...props}
            className={cn(
                'text-foreground decoration-neutral-300 transition-colors duration-300 ease-out hover:decoration-current!',
                className,
            )}
        />
    );
}
