import { cn } from '@/lib/utils';
import { HTMLAttributes } from 'react';

type Props = HTMLAttributes<HTMLParagraphElement> & {
    message?: string;
}

export default function InputError({ className = '', message, ...props }: Props) {
    return message ? <p {...props} className={cn('text-sm text-destructive', className)}>{message}</p> : null;
}
