import { cn } from '@/lib/utils';

type Props = {
    label?: string;
    theme?: 'light' | 'dark'
}

const EmptyData = ({ label = 'No data found', theme = 'dark' }: Props) => {
    return (
        <div>
            <img src="/empty.svg" alt="Empty Data" className="w-64 h-auto mx-auto" />
            <p className={cn(
                "text-center",
                theme === 'dark' && 'text-white',
                theme === 'light' && 'text-black',
            )}>{label}</p>
        </div>
    );
};

export default EmptyData;
