import { Appearance, useAppearance } from '@/hooks/use-appearance';
import { cn } from '@/lib/utils';
import { LucideIcon, Monitor, Moon, Sun } from 'lucide-react';
import { HTMLAttributes } from 'react';

export default function AppearanceToggleTab({ className = '', ...props }: HTMLAttributes<HTMLDivElement>) {
    const { appearance, updateAppearance } = useAppearance();

    const tabs: { value: Appearance; icon: LucideIcon; label: string; disabled?: boolean }[] = [
        { value: 'light', icon: Sun, label: 'Light Mode' },
        { value: 'dark', icon: Moon, label: 'Dark Mode (Disabled)', disabled: true },
        { value: 'system', icon: Monitor, label: 'System (Disabled)', disabled: true },
    ];

    return (
        <div className={cn('inline-flex gap-1 rounded-lg bg-neutral-100 p-1', className)} {...props}>
            {tabs.map(({ value, icon: Icon, label, disabled }) => (
                <button
                    key={value}
                    onClick={() => !disabled && updateAppearance(value)}
                    disabled={disabled}
                    className={cn(
                        'flex items-center rounded-md px-3.5 py-1.5 transition-colors',
                        appearance === value && !disabled
                            ? 'bg-white shadow-xs'
                            : disabled
                            ? 'text-neutral-400 cursor-not-allowed opacity-50'
                            : 'text-neutral-500 hover:bg-neutral-200/60 hover:text-black',
                    )}
                >
                    <Icon className="-ml-1 h-4 w-4" />
                    <span className="ml-1.5 text-sm">{label}</span>
                </button>
            ))}
        </div>
    );
}
