import { Button } from '@/components/ui/button';
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from '@/components/ui/dropdown-menu';
import { useAppearance } from '@/hooks/use-appearance';
import { Monitor, Moon, Sun } from 'lucide-react';
import { HTMLAttributes } from 'react';

export default function AppearanceToggleDropdown({ className = '', ...props }: HTMLAttributes<HTMLDivElement>) {
    const { appearance, updateAppearance } = useAppearance();

    const getCurrentIcon = () => {
        // Always show sun icon since we only support light mode
        return <Sun className="h-5 w-5" />;
    };

    return (
        <div className={className} {...props}>
            <DropdownMenu>
                <DropdownMenuTrigger asChild>
                    <Button variant="ghost" size="icon" className="h-9 w-9 rounded-md">
                        {getCurrentIcon()}
                        <span className="sr-only">Light mode only</span>
                    </Button>
                </DropdownMenuTrigger>
                <DropdownMenuContent align="end">
                    <DropdownMenuItem disabled className="opacity-50 cursor-not-allowed">
                        <span className="flex items-center gap-2">
                            <Sun className="h-5 w-5" />
                            Light Mode (Default)
                        </span>
                    </DropdownMenuItem>
                    <DropdownMenuItem disabled className="opacity-50 cursor-not-allowed">
                        <span className="flex items-center gap-2">
                            <Moon className="h-5 w-5" />
                            Dark Mode (Disabled)
                        </span>
                    </DropdownMenuItem>
                    <DropdownMenuItem disabled className="opacity-50 cursor-not-allowed">
                        <span className="flex items-center gap-2">
                            <Monitor className="h-5 w-5" />
                            System (Disabled)
                        </span>
                    </DropdownMenuItem>
                </DropdownMenuContent>
            </DropdownMenu>
        </div>
    );
}
