import { Link } from '@inertiajs/react';
import { Button } from '@/components/ui/button';
import { Settings, Users, CreditCard } from 'lucide-react';

interface AdminNavProps {
    userRole: string;
}

export default function AdminNav({ userRole }: AdminNavProps) {
    if (userRole !== 'admin') {
        return null;
    }

    return (
        <div className="bg-blue-600 text-white p-4">
            <div className="max-w-7xl mx-auto">
                <div className="flex items-center justify-between">
                    <div className="flex items-center space-x-4">
                        <h2 className="text-lg font-semibold">Admin Panel</h2>
                        <div className="flex space-x-2">
                            <Link href={route('admin.dashboard')}>
                                <Button variant="outline" size="sm" className="text-blue-600 bg-white hover:bg-gray-100">
                                    <Settings className="w-4 h-4 mr-1" />
                                    Dashboard
                                </Button>
                            </Link>
                            <Link href={route('admin.users.index')}>
                                <Button variant="outline" size="sm" className="text-blue-600 bg-white hover:bg-gray-100">
                                    <Users className="w-4 h-4 mr-1" />
                                    Pengguna
                                </Button>
                            </Link>
                            <Link href={route('admin.transactions.index')}>
                                <Button variant="outline" size="sm" className="text-blue-600 bg-white hover:bg-gray-100">
                                    <CreditCard className="w-4 h-4 mr-1" />
                                    Transaksi
                                </Button>
                            </Link>
                        </div>
                    </div>
                    <div className="text-sm">
                        <span className="bg-blue-700 px-2 py-1 rounded">Admin Access</span>
                    </div>
                </div>
            </div>
        </div>
    );
}
