import { type ReactElement, SVGProps } from 'react';

interface ApplicationLogoProps extends SVGProps<SVGSVGElement> {
    className?: string;
}

export default function ApplicationLogo({ className = '' }: ApplicationLogoProps) {
    return (
        <svg
            className={`h-8 w-auto ${className}`}
            viewBox="0 0 40 40"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M20 0C8.954 0 0 8.954 0 20s8.954 20 20 20 20-8.954 20-20S31.046 0 20 0zm0 36c-8.837 0-16-7.163-16-16S11.163 4 20 4s16 7.163 16 16-7.163 16-16 16z"
                fill="currentColor"
            />
            <path
                d="M20 8c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm0 22c-5.514 0-10-4.486-10-10S14.486 10 20 10s10 4.486 10 10-4.486 10-10 10z"
                fill="currentColor"
            />
            <path
                d="M20 14c-3.314 0-6 2.686-6 6s2.686 6 6 6 6-2.686 6-6-2.686-6-6-6zm0 10c-2.206 0-4-1.794-4-4s1.794-4 4-4 4 1.794 4 4-1.794 4-4 4z"
                fill="currentColor"
            />
        </svg>
    );
}
