<?php

namespace Database\Seeders;

use App\Models\SystemSetting;
use Illuminate\Database\Seeder;

class SystemSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Default max upload size (2MB = 2048 KB)
        SystemSetting::setValue(
            'max_upload_size',
            2048,
            'integer',
            'Maximum file upload size in KB'
        );

        // Default new user balance
        SystemSetting::setValue(
            'new_user_balance',
            30000.00,
            'string',
            'Default balance for new users'
        );

        $this->command->info('Default system settings created successfully.');
    }
}
