<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('verification_icons', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // 'verified' or 'unverified'
            $table->string('icon_path'); // Path to the icon image
            $table->string('description')->nullable(); // Description of the icon
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('verification_icons');
    }
};
