<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('news', function (Blueprint $table) {
            // Drop columns we no longer need
            $table->dropColumn(['slug', 'content', 'is_published', 'published_at']);
            
            // Rename featured_image to image
            $table->renameColumn('featured_image', 'image');
            
            // Add description column
            $table->text('description')->after('title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('news', function (Blueprint $table) {
            // Restore original columns
            $table->string('slug')->unique();
            $table->text('content');
            $table->boolean('is_published')->default(false);
            $table->timestamp('published_at')->nullable();
            
            // Rename image back to featured_image
            $table->renameColumn('image', 'featured_image');
            
            // Drop description column
            $table->dropColumn('description');
        });
    }
};
