<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Ticket extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'description',
        'status',
        'priority',
        'user_id',
        'resolved_at',
        'attachments',
        'is_read',
        'last_viewed_by_admin',
    ];

    protected $casts = [
        'resolved_at' => 'datetime',
        'attachments' => 'array',
        'is_read' => 'boolean',
        'last_viewed_by_admin' => 'datetime',
        'user_id' => 'integer'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function replies()
    {
        return $this->hasMany(TicketReply::class);
    }
}
