<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class EmailVerificationPromptController extends Controller
{
    /**
     * Show the email verification prompt page.
     */
    public function __invoke(Request $request): Response|RedirectResponse
    {
        // Check if user is authenticated
        if (!$request->user()) {
            // For guest users, just show the verification notice page
            return Inertia::render('auth/verify-email', [
                'status' => $request->session()->get('status'),
                'isGuest' => true
            ]);
        }

        $user = $request->user();
        
        // If user is already verified, redirect them to appropriate dashboard
        if ($user->hasVerifiedEmail()) {
            if ($user->role === 'admin') {
                return redirect()->intended(route('admin.dashboard', absolute: false));
            }
            return redirect()->intended(route('home', absolute: false));
        }

        // User is authenticated but not verified - show verification page
        return Inertia::render('auth/verify-email', [
            'status' => $request->session()->get('status'),
            'isGuest' => false
        ]);
    }
}
