<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SystemSetting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SystemSettingController extends Controller
{
    public function index()
    {
        $settings = [
            'max_upload_size' => SystemSetting::getMaxUploadSize(),
            'new_user_balance' => SystemSetting::getNewUserBalance(),
        ];

        return Inertia::render('admin/system-settings/index', [
            'settings' => $settings,
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'max_upload_size' => 'required|integer|min:1|max:10000', // Max 10MB
            'new_user_balance' => 'required|numeric|min:0|max:1000000', // Max 1M
        ]);

        // Update max upload size
        SystemSetting::setValue(
            'max_upload_size',
            $validated['max_upload_size'],
            'integer',
            'Maximum file upload size in KB'
        );

        // Update new user balance
        SystemSetting::setValue(
            'new_user_balance',
            $validated['new_user_balance'],
            'string',
            'Default balance for new users'
        );

        return back()->with('message', 'System settings updated successfully.');
    }
}
