<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index()
    {
        // Get statistics for admin dashboard
        $stats = [
            'total_users' => User::count(),
            'total_transactions' => Transaction::count(),
            'pending_transactions' => Transaction::where('status', 'pending')->count(),
            'processing_transactions' => Transaction::where('status', 'processing')->count(),
            'completed_transactions' => Transaction::where('status', 'completed')->count(),
            'failed_transactions' => Transaction::where('status', 'failed')->count(),
            'total_amount' => Transaction::where('status', 'completed')->sum('amount'),
            'today_transactions' => Transaction::whereDate('created_at', today())->count(),
        ];

        // Get recent transactions
        $recent_transactions = Transaction::with('user')
            ->latest()
            ->take(5)
            ->get();

        // Get recent users
        $recent_users = User::latest()
            ->take(5)
            ->get();

        // Get transaction counts by type
        $transactions_by_type = Transaction::selectRaw('type, COUNT(*) as count')
            ->groupBy('type')
            ->get();

        // Get transaction counts by status
        $transactions_by_status = Transaction::selectRaw('status, COUNT(*) as count')
            ->groupBy('status')
            ->get();

        return Inertia::render('admin/dashboard', [
            'stats' => $stats,
            'recent_transactions' => $recent_transactions,
            'recent_users' => $recent_users,
            'transactions_by_type' => $transactions_by_type,
            'transactions_by_status' => $transactions_by_status,
        ]);
    }
}
